/**********************************************************************************************************************					
Instituto Nacional de Estadstica (INE) www.ine.es					
***********************************************************************************************************************					
					
DESCRIPCIN:					
Este programa genera un fichero SAS con formatos, partiendo de un fichero sin ellos.					
					
Consta de las siguientes partes:					
	* 1. Definir la librera de trabajo --> Libname				
	* 2. Definicin de formatos --> PROC FORMAT				
	* 3. Vincular formatos a la base de datos --> PASO data				
					
 Entrada:                                                           					
     - Fichero SAS sin formatos: 	 EDADdiscapacidad_2020.sas7bdat				
 Salida:                                                           					
     - Fichero SAS con formatos: 	 EDADdiscapacidad_2020_conFormato.sas7bdat				
					
Donde:					
	* Operacin: Encuesta de Discapacidad, Autonoma personal y Situaciones de dependencia(EDADdiscapacidad)
	* Periodo: 2020
					
************************************************************************************************************************/					
		
/* Directorio de trabajo para la operacin estadstica */
*%let siglas_periodo = EDADdiscapacidad_2020;
*%let conFormato = _conFormato;
					
/*1) Definir la librera de trabajo: introducir el directorio que desee como librera					
(se da como ejemplo 'C:\Mis resultados'), y copiar en ese directorio el fichero sas "EDADdiscapacidad_2018.sas7bdat"*/					
					
*libname ROutput 'C:\Mis resultados';	

options fmtsearch = (ROutput ROutput.cat1);

* 2) DEFINICIN DE FORMATOS;
PROC FORMAT LIBRARY=ROutput.cat1;

value $TCCAA

"01"="Andaluca"
"02"="Aragn"
"03"="Principado de Asturias"
"04"="Illes Balears"
"05"="Canarias"
"06"="Cantabria"
"07"="Castilla y Len"
"08"="Castilla - La Mancha"
"09"="Catalua"
"10"="Comunitat Valenciana"
"11"="Extremadura"
"12"="Galicia"
"13"="Comunidad de Madrid"
"14"="Regin de Murcia"
"15"="Comunidad Foral de Navarra"
"16"="Pas Vasco"
"17"="La Rioja"
"18"="Ceuta"
"19"="Melilla"
;
value $TMUNIC

"1"="Capital de provincia y municipios de ms de 100.000 habitantes"
"2"="De 50.000 a 100.000 habitantes"
"3"="De 20.000 a menos de 50.000 habitantes"
"4"="De 10.000 a menos de 20.000 habitantes"
"5"="Menos de 10.000 habitantes"
;
value $TRELAC

"1"="Cnyuge o pareja"
"2"="Hijo/a"
"3"="Padre/Madre"
"4"="Hermano/a"
"5"="Otros familiares"
"6"="Servicios sociales"
"7"="Voluntarios"
"8"="Otros"
"9"="NC"
;
value $TPROXY

"1"="Ausencia prolongada"
"2"="Discapacidad o enfermedad grave que le impide contestar"
"3"="Desconocimiento del idioma"
"4"="Menor de edad"
;
value $T1CAUSA

"01"="Problema congnito"
"02"="Problemas de parto"
"03"="Accidente"
"04"="Enfermedad"
"05"="Proceso degenerativo derivado de la edad"
"06"="Otras causas"
"99"="NC"
;
value $T2CAUSA

"01"="Accidente laboral"
"02"="Accidente domstico"
"03"="Accidente de ocio"
"04"="Otro tipo de accidente"
"99"="NC"
;
value $T3CAUSA

"01"="Enfermedad profesional"
"02"="Enfermedad comn"
"99"="NC"
;
value $T4CAUSA

"01"="Accidente de trfico"
"02"="Cada"
"03"="Otro tipo de accidente"
"99"="NC"
;
value $T5CAUSA

"01"="Cncer o tumor"
"02"="Enfermedad cerebrovascular"
"03"="Enfermedad corazn"
"04"="Enfermedad reumtica"
"05"="Enfermedad mental"
"06"="Enfermedad o proceso degenerativo derivado de la edad"
"07"="Otro tipo de enfermedad"
"99"="NC"
;
value $TSALUD

"1"="Muy bueno"
"2"="Bueno"
"3"="Regular"
"4"="Malo"
"5"="Muy malo"
"9"="NS/NC"
;
value $TDISCRI

"1"="Nunca"
"2"="Algunas veces"
"3"="Muchas veces"
"4"="Constantemente"
"9"="NS/NC"
;
value $TEDUCA

"1"="No est escolarizado/a"
"2"="Est escolarizado/a en un centro de educacin especial"
"3"="Est escolarizado/a en un aula de educacin especial en un centro ordinario"
"4"="Est escolarizado/a en un centro ordinario recibiendo apoyos personalizados"
"5"="Est escolarizado/a en un centro ordinario sin ningn tipo personalizado de apoyo"
"6"="Otro tipo de escolarizacin"
"9"="NC"
;
value $T1MOTIV

"1"="Por decisin familiar"
"2"="Por indicacin de un profesional o especialista"
"3"="Por decisin de la Administracin"
"4"="No haba otras opciones factibles"
"5"="Por otro motivo"
"9"="NC"
;
value $TTITULA

"1"="Centro pblico"
"2"="Cenro concertado"
"3"="Centro privado"
"9"="NC"
;
value $T1ADAP

"1"="S"
"2"="No, no ha sido necesario hacer adaptaciones"
"3"="No, no se han realizando pero hubieran sido necesarias"
"9"="NC"
;
value $T2ADAP

"1"="S, he recibido los apoyos y adaptaciones suficientes"
"2"="S, he recibido apoyos pero no los suficientes"
"3"="No, no los he necesitado"
"4"="No, los he necesitado y no los he recibido"
"9"="NC"
;
value $T1DIAS

"1"="Ningn da"
"2"="De 1 a 7 das"
"3"="De 8 a 14 das"
"4"="De 15 das a un mes"
"5"="Entre uno y tres meses"
"6"="Mas de tres meses"
"9"="NC"
;
value $TESTUDI

"01"="Educacin Secundaria Obligatoria (ESO). Centro ordinario"
"02"="Educacin Secundaria Obligatoria (ESO). Centro especial"
"03"="Bachillerato"
"04"="Formacin profesional bsica"
"05"="Formacin profesional grado medio"
"06"="Formacin profesional grado superior"
"07"="Estudios universitarios (Grado o postgrado universitario)"
"08"="Educacin especial"
"09"="Cursos de Formacion profesional ocupacional. Centro ordinario"
"10"="Cursos de Formacion profesional ocupacional. Centro especial"
"11"="Otros cursos o estudios de duracion superior a seis meses"
"12"="Otros cursos o estudios de duracion inferior a seis meses"
"99"="NC"
;
value $TBECA

"1"="S, recibo una beca o ayuda al estudio por motivo de mi discapacidad"
"2"="S, recibo una beca o ayuda al estudio por otro motivo"
"3"="No, no recibo ninguna beca o ayuda al estudio"
"9"="NC"
;
value $TLABOR

"1"="Trabajando"
"2"="No trabajo, pero he trabajado antes"
"3"="Nunca he trabajado"
"9"="NC"
;
value $TMODALI

"01"="Trabajador del sector pblico."
"02"="Empleado en un centro especial de empleo. CEE de iniciativa pblica"
"03"="Empleado en un centro especial de empleo. CEE de iniciativa social"
"04"="Empleado en un centro especial de empleo. CEE de iniciativa privada"
"05"="Empleado en un centro especial de empleo. No sabe"
"06"="Empleado en Entidad sin nimo de lucro. Entidad no vinculada al sector de la discapacidad"
"07"="Empleado en Entidad sin nimo de lucro. Entidad vinculada al sector de la discapacidad"
"08"="Empleado en Entidad sin nimo de lucro.No sabe"
"09"="Trabajador por cuenta ajena (sector privado)"
"10"="Trabajador por cuenta propia sin asalariados"
"11"="Ayuda familar"
"12"="Miembro de cooperativa o similar"
"13"="Empresario(o trabajador por cuenta propia) con asalariados"
"14"="Otra modalidad de empleo"
"99"="NC"
;
value $TCONTRA

"1"="Contrato indefinido"
"2"="Contrato temporal"
"3"="Contrato verbal o sin contrato"
"9"="NC"
;
value $TJORNAD

"1"="Jornada completa"
"2"="Jornada reducida o parcial"
"3"="Otro tipo de jornada"
"9"="NC"
;
value $TTAMANO

"1"="Menos de 10 personas ocupadas"
"2"="De 10 a 49 personas ocupadas"
"3"="De 50 a 249 personas ocupadas"
"4"="Ms de 250 personas ocupadas"
"9"="NC"
;
value $T2MOTIV

"1"="Debido a la aparicin o agravamiento de mi discapacidad"
"2"="Por otras razones de salud"
"3"="Jubilacin anticipada por motivo de mi discapacidad"
"4"="Por jubilacin (voluntaria o forzosa)"
"5"="Por ser despedido o quedar en situacin de desempleo"
"6"="Por propia voluntad"
"7"="Por otras razones"
"9"="NC"
;
value $T1TIEMP

"1"="Menos de un ao"
"2"="Ms de un ao pero menos de dos"
"3"="Ms de dos pero menos de cinco"
"4"="Cinco o ms aos"
"9"="NC"
;
value $TRAZON

"1"="Debido a mi discapacidad"
"2"="Falta de experiencia o cualificacin"
"3"="Mercado laboral:encontrar trabajo es difcil para cualquiera"
"4"="Ausencia de oferta: no encuentro el tipo de trabajo que busco"
"5"="Llevo poco tiempo buscando empleo"
"6"="Otras razones"
"9"="NC"
;
value $T3MOTIV

"1"="Debido a mi discapacidad"
"2"="Otras razones de salud"
"3"="No me ha merecido la pena"
"4"="Por estar estudiando"
"5"="Otros motivoS personales o familiares"
"6"="Otras razones"
"9"="NC"
;
value $TFRECU

"1"="Todos o casi todos los das"
"2"="Una o dos veces por semana"
"3"="Una o dos veces al mes"
"4"="Menos de una vez al mes"
"9"="NC"
;
value $TVALORA

"1"="Excesivo"
"2"="Adecuado"
"3"="Insuficiente"
"4"="No tengo ningn contacto con mi familia"
"9"="NC"
;
value $T3RAZON

"1"="A causa de mi discapacidad"
"2"="No tiene ninguna aficin ni inters"
"3"="No tiene apenas tiempo libre"
"4"="Otro motivo"
"9"="NC"
;
value $TSATIFA

"1"="Muy satisfecho/a"
"2"="Satisfecho/a"
"3"="Ni satisfecho/a ni insatisfecho/a"
"4"="Insatisfecho/a"
"5"="Muy insatisfecho/a"
"9"="NC"
;
value $T4MOTIV

"1"="Para poder recibir mejor atencin familiar"
"2"="Para evitar las barreras de acceso que tena en mi anterior domicilio"
"3"="Para evitar las barreras que tena en el interior de mi anterior domicilio"
"4"="para tener mejor disponibilidad de resursos sanitarios o sociales"
"5"="Por razones medioambientales (climatolgicas, contaminacin,)"
"6"="Por tener que ingresar (por un perodo superior a 6 meses) en un centro hospitalario, residencia u otro establecimiento colectivo"
"7"="Otro tipo de razn"
"9"="NC"
;
value $TMEJORA

"1"="S, los ha mejorado mucho"
"2"="S, los ha mejorado algo"
"3"="No ha mejorado ni ha empeorado"
"4"="Ha empeorado mi vida diaria"
"9"="NC"
;
value $TPERSON

"01"="Mi mujer o pareja"
"02"="Mi marido o pareja"
"03"="Mi madre"
"04"="Mi padre"
"05"="Mi hija"
"06"="Mi hijo"
"07"="Otro familiar"
"08"="Persona empleada en el hogar"
"09"="Personal socio-sanitario"
"10"="Asistente personal"
"11"="Otra persona distinta a las anteriores"
"99"="NC"
;
value $TGASTO

"01"="Gasto asociado a la discapacidad. Ayudas tcnicas"
"02"="Gasto asociado a la discapacidad. Adaptaciones"
"03"="Gasto asociado a la discapacidad. Asistencia personal"
"04"="Gasto asociado a la discapacidad. Tratamientos mdicos"
"05"="Gasto asociado a la discapacidad. Medicamentos"
"06"="Gasto asociado a la discapacidad. Trasporte y desplazamientos"
"07"="Gasto asociado a la discapacidad. Escolarizacin"
"08"="Gasto asociado a la discapacidad. Vivienda"
"09"="Gasto asociado a la discapacidad. Equipamiento hogar"
"10"="Gasto asociado a la discapacidad. Ropa y utiles personales"
"11"="Gasto asociado a la discapacidad. Proteccin legal"
"12"="Gasto asociado a la discapacidad. Proteccin, previsin econmica"
"13"="Gasto asociado a la discapacidad. Trmites, gestin, administracin"
"14"="Gasto asociado a la discapacidad. Otros gastos"
"99"="NC"
;
value $T2PROXY

"1"="Ausencia prolongada"
"2"="Discapacidad o enfermedad grave que le impide contestar"
"3"="Desconocimiento del idioma"
;
value $TENTREV

"1"="Personal"
"6"="Telefnica"
;
value $T2TIEMP

"1"="Menos de 1 ao"
"2"="De 1 hasta 2 aos"
"3"="De 2 hasta 4 aos"
"4"="De 4 hasta 8 aos"
"5"="8 y ms aos"
"9"="NC"
;
value $T2DIAS

"0"="Menos de 1 da"
"7"="Los 7 das de la semana"
"9"="NC"
;
value $T2SEXO

"1"="Hombre"
"2"="Mujer"
;
value $T6SEXO

"1"="Hombre"
"6"="Mujer"
;

value $TSiNo

"1"="S"
"6"="No"
"9"="NC"
;
value $T1NIVEL

"1"="Con dificultad moderada"
"2"="Con gran dificultad"
"3"="No puede realizar la actividad por s mismo"
"9"="NS/NC"
;
value $T2NIVEL

"1"="Sin dificultad o con poca dificultad"
"2"="Con dificultad moderada"
"3"="Con gran dificultad"
"4"="No puede realizar la actividad por s mismo"
"9"="NS/NC"
;
value $TNACIO

"1"="Espaola"
"2"="Extranjera"
"3"="Espaola y otra"
"9"="NC"
;
value $TECIVIL

"1"="Soltero"
"2"="Casado"
"3"="Viudo"
"4"="Separado legalmente"
"5"="Divorciado"
"9"="NC"
;
value $TESTUD

"01"="No sabe leer ni escribir"
"02"="Estudios primarios incompletos"
"03"="Estudios primarios o equivalentes"
"04"="Educacin secundaria de 1 etapa"
"05"="Estudios de bachillerato"
"06"="Enseanza profesional de grado medio"
"07"="Enseanzas profesionales superiores"
"08"="Estudios universitarios o equivalentes"
"99"="NC"
;
value $T2ACTI

"1"="Trabajando"
"2"="No trabaja"
"3"="Jubilado/a, prejubilado/a, retirado/a de una actividad econmica previa"
"4"="Incapacitado/a para trabajar"
"9"="NC"
;
value $TACTECO

"1"="Trabajando"
"2"="Buscando empleo"
"3"="No trabajando ni busca empleo"
"9"="NC"
;
value $TDEFICI

"11"="Retraso madurativo"
"12"="Deficiencia intelectual profunda y severa"
"13"="Deficiencia intelectual moderada"
"14"="Deficiencia intelectual leve"
"15"="Inteligencia lmite"
"16"="Demencias"
"17"="Enfermedad mental"
"18"="Otros transtornos mentales"
"21"="Ceguera total"
"22"="Mala visin"
"31"="Sordera prelocutiva"
"32"="Sordera postlocutiva"
"33"="Mala audicin"
"34"="Trastornos del equilibrio"
"41"="Mudez (no por sordera)"
"42"="Habla dificultosa o incomprensible"
"51"="Cabeza"
"52"="Columna vertebral"
"53"="Extremidades superiores"
"54"="Extremidades inferiores"
"61"="Parlisis de una extremidad superior"
"62"="Parlisis de una extremidad inferior"
"63"="Paraplejia"
"64"="Tetraplejia"
"65"="Trastornos de la coordinacin de movimientos y/o tono muscular"
"66"="Otras deficiencias del sistema nervioso"
"71"="Aparato respiratorio"
"72"="Aparato cardiovascular"
"73"="Aparato digestivo"
"74"="Aparato genitourinario"
"75"="Sistema endocrino-metablico"
"76"="Sistema hematopoytico y sistema inmunitario"
"81"="Piel"
"82"="Deficiencias mltiples"
"83"="Deficiencias no clasificadas en otra parte"
"99"="No consta"
;
value $TOCUPA

"00"="Ocupaciones militares"
"01"="Directores y gerentes"
"02"="Tcnicos y profesionales cientficos e intelectuales"
"03"="Tcnicos; profesionales de apoyo"
"04"="Empleados contables, administrativos y otros empleados de oficina"
"05"="Trabajadores de los servicios de restauracin, personales, proteccin y vendedores"
"06"="Trabajadores cualificados en el sector agrcola, ganadero, forestal y pesquero"
"07"="Artesanos y trabajadores cualificados de las industrias manufactureras y la construccin (excepto operadores de instalaciones y maquinaria)"
"08"="Operadores de instalaciones y maquinaria, y montadores"
"09"="Ocupaciones elementales"
"99"="NC"
;
value $TACTIVI

"1"="Agricultura, ganadera, silvicultura y pesca"
"2"="Industria"
"3"="Construccin"
"4"="Comercio al por mayor y al por menor; reparaciones de vehculos y motocicletas"
"5"="Administracin Pblica, Defensa, Seguridad Social obligatoria"
"6"="Educacin"
"7"="Actividades Sanitarias y de Servicios Sociales"
"8"="Otras actividades de Servicios"
"9"="NC"
;




* 3) VINCULAR FORMATOS A LA BASE DE DATOS;

	DATA ROutput.&siglas_periodo.&conFormato;
		set ROutput.&siglas_periodo;


FORMAT CCAA $TCCAA.;
FORMAT TMUNI $TMUNIC.;


FORMAT SEXO $T2SEXO.;

FORMAT INFOR_DISC $TSiNo.;
FORMAT INFOR_HOG $TSiNo.;
FORMAT INFOR_RELAC $TRELAC.;
FORMAT PROXY $TPROXY.;
FORMAT VISI_1_1 $TSiNo.;
FORMAT VISI_2_1 $TSiNo.;
FORMAT VISI_2_2 $T1NIVEL.;
FORMAT VISI_2_3 $TSiNo.;
FORMAT VISI_2_4 $T2NIVEL.;
FORMAT VISI_3_1 $TSiNo.;
FORMAT VISI_3_2 $T1NIVEL.;
FORMAT VISI_3_3 $TSiNo.;
FORMAT VISI_3_4 $T2NIVEL.;
FORMAT VISI_4_1 $TSiNo.;
FORMAT VISI_4_2 $T1NIVEL.;
FORMAT VISI_4_3 $TSiNo.;
FORMAT VISI_4_4 $T2NIVEL.;
FORMAT VISIC1_1 $TSiNo.;

FORMAT VISIC1_3 $TSiNo.;
FORMAT VISIC1_4 $TSiNo.;

FORMAT VISIC1_6_1 $TDEFICI.;
FORMAT VISIC1_6_2 $TDEFICI.;
FORMAT VISIC1_6_3 $TDEFICI.;
FORMAT VISIC1_6_4 $TDEFICI.;
FORMAT VISIC1_7 $TDEFICI.;
FORMAT VISIC1_8 $T1CAUSA.;
FORMAT VISIC1_8a $T2CAUSA.;
FORMAT VISIC1_8b $T3CAUSA.;
FORMAT VISIC1_8c $T4CAUSA.;
FORMAT VISIC1_8d $T5CAUSA.;

FORMAT VISIC1_10_1 $TSiNo.;
FORMAT VISIC1_10_2 $TSiNo.;
FORMAT VISIC1_10_3 $TSiNo.;
FORMAT VISIC1_10_4 $TSiNo.;
FORMAT VISIC1_10_5 $TSiNo.;
FORMAT VISIC1_10_6 $TSiNo.;
FORMAT AUDI_5_1 $TSiNo.;
FORMAT AUDI_6_1 $TSiNo.;
FORMAT AUDI_6_2 $T1NIVEL.;
FORMAT AUDI_6_3 $TSiNo.;
FORMAT AUDI_6_4 $T2NIVEL.;
FORMAT AUDI_7_1 $TSiNo.;
FORMAT AUDI_7_2 $T1NIVEL.;
FORMAT AUDI_7_3 $TSiNo.;
FORMAT AUDI_7_4 $T2NIVEL.;
FORMAT AUDIC2_1 $TSiNo.;

FORMAT AUDIC2_3 $TSiNo.;

FORMAT AUDIC2_5 $TSiNo.;
FORMAT AUDIC2_6 $TSiNo.;

FORMAT AUDIC2_8_1 $TDEFICI.;
FORMAT AUDIC2_8_2 $TDEFICI.;
FORMAT AUDIC2_8_3 $TDEFICI.;
FORMAT AUDIC2_8_4 $TDEFICI.;
FORMAT AUDIC2_9 $TDEFICI.;
FORMAT AUDIC2_10 $T1CAUSA.;
FORMAT AUDIC2_10a $T2CAUSA.;
FORMAT AUDIC2_10b $T3CAUSA.;
FORMAT AUDIC2_10c $T4CAUSA.;
FORMAT AUDIC2_10d $T5CAUSA.;

FORMAT COMU_8_1 $TSiNo.;
FORMAT COMU_8_2 $T1NIVEL.;
FORMAT COMU_8_3 $TSiNo.;
FORMAT COMU_8_4 $T2NIVEL.;
FORMAT COMU_9_1 $TSiNo.;
FORMAT COMU_9_2 $T1NIVEL.;
FORMAT COMU_9_3 $TSiNo.;
FORMAT COMU_9_4 $T2NIVEL.;
FORMAT COMU_10_1 $TSiNo.;
FORMAT COMU_10_2 $T1NIVEL.;
FORMAT COMU_11_1 $TSiNo.;
FORMAT COMU_11_2 $T1NIVEL.;
FORMAT COMU_12_1 $TSiNo.;
FORMAT COMU_12_2 $T1NIVEL.;
FORMAT COMU_13_1 $TSiNo.;
FORMAT COMU_13_2 $T1NIVEL.;
FORMAT COMU_13_3 $TSiNo.;
FORMAT COMU_13_4 $T2NIVEL.;
FORMAT COMU_14_1 $TSiNo.;
FORMAT COMU_14_2 $T1NIVEL.;
FORMAT COMU_14_3 $TSiNo.;
FORMAT COMU_14_4 $T2NIVEL.;
FORMAT COMUC3_1 $TSiNo.;
FORMAT COMUC3_2 $TSiNo.;

FORMAT COMUC3_4_1 $TDEFICI.;
FORMAT COMUC3_4_2 $TDEFICI.;
FORMAT COMUC3_4_3 $TDEFICI.;
FORMAT COMUC3_4_4 $TDEFICI.;
FORMAT COMUC3_5 $TDEFICI.;
FORMAT COMUC3_6 $T1CAUSA.;
FORMAT COMUC3_6a $T2CAUSA.;
FORMAT COMUC3_6b $T3CAUSA.;
FORMAT COMUC3_6c $T4CAUSA.;
FORMAT COMUC3_6d $T5CAUSA.;

FORMAT APRE_15_1 $TSiNo.;
FORMAT APRE_15_2 $T1NIVEL.;
FORMAT APRE_16_1 $TSiNo.;
FORMAT APRE_16_2 $T1NIVEL.;
FORMAT APRE_16_3 $TSiNo.;
FORMAT APRE_16_4 $T2NIVEL.;
FORMAT APRE_17_1 $TSiNo.;
FORMAT APRE_17_2 $T1NIVEL.;
FORMAT APRE_17_3 $TSiNo.;
FORMAT APRE_17_4 $T2NIVEL.;
FORMAT APRE_18_1 $TSiNo.;
FORMAT APRE_18_2 $T1NIVEL.;
FORMAT APRE_18_3 $TSiNo.;
FORMAT APRE_18_4 $T2NIVEL.;
FORMAT APREC4_1 $TSiNo.;
FORMAT APREC4_2 $TSiNo.;

FORMAT APREC4_4_1 $TDEFICI.;
FORMAT APREC4_4_2 $TDEFICI.;
FORMAT APREC4_4_3 $TDEFICI.;
FORMAT APREC4_4_4 $TDEFICI.;
FORMAT APREC4_5 $TDEFICI.;
FORMAT APREC4_6 $T1CAUSA.;
FORMAT APREC4_6a $T2CAUSA.;
FORMAT APREC4_6b $T3CAUSA.;
FORMAT APREC4_6c $T4CAUSA.;
FORMAT APREC4_6d $T5CAUSA.;

FORMAT MOVI_19_1 $TSiNo.;
FORMAT MOVI_19_2 $T1NIVEL.;
FORMAT MOVI_19_3 $TSiNo.;
FORMAT MOVI_19_4 $T2NIVEL.;
FORMAT MOVI_20_1 $TSiNo.;
FORMAT MOVI_20_2 $T1NIVEL.;
FORMAT MOVI_20_3 $TSiNo.;
FORMAT MOVI_20_4 $T2NIVEL.;
FORMAT MOVI_21_1 $TSiNo.;
FORMAT MOVI_21_2 $T1NIVEL.;
FORMAT MOVI_21_3 $TSiNo.;
FORMAT MOVI_21_4 $T2NIVEL.;
FORMAT MOVI_22_1 $TSiNo.;
FORMAT MOVI_22_2 $T1NIVEL.;
FORMAT MOVI_22_3 $TSiNo.;
FORMAT MOVI_22_4 $T2NIVEL.;
FORMAT MOVI_23_1 $TSiNo.;
FORMAT MOVI_23_2 $T1NIVEL.;
FORMAT MOVI_23_3 $TSiNo.;
FORMAT MOVI_23_4 $T2NIVEL.;
FORMAT MOVI_24_1 $TSiNo.;
FORMAT MOVI_24_2 $T1NIVEL.;
FORMAT MOVI_24_3 $TSiNo.;
FORMAT MOVI_24_4 $T2NIVEL.;
FORMAT MOVI_25_1 $TSiNo.;
FORMAT MOVI_25_2 $T1NIVEL.;
FORMAT MOVI_25_3 $TSiNo.;
FORMAT MOVI_25_4 $T2NIVEL.;
FORMAT MOVI_26_1 $TSiNo.;
FORMAT MOVI_26_2 $T1NIVEL.;
FORMAT MOVI_26_3 $TSiNo.;
FORMAT MOVI_26_4 $T2NIVEL.;
FORMAT MOVIC5_1 $TSiNo.;
FORMAT MOVIC5_2 $TSiNo.;

FORMAT MOVIC5_4_1 $TDEFICI.;
FORMAT MOVIC5_4_2 $TDEFICI.;
FORMAT MOVIC5_4_3 $TDEFICI.;
FORMAT MOVIC5_4_4 $TDEFICI.;
FORMAT MOVIC5_5 $TDEFICI.;
FORMAT MOVIC5_6 $T1CAUSA.;
FORMAT MOVIC5_6a $T2CAUSA.;
FORMAT MOVIC5_6b $T3CAUSA.;
FORMAT MOVIC5_6c $T4CAUSA.;
FORMAT MOVIC5_6d $T5CAUSA.;

FORMAT AUTO_27_1 $TSiNo.;
FORMAT AUTO_27_2 $T1NIVEL.;
FORMAT AUTO_27_3 $TSiNo.;
FORMAT AUTO_27_4 $T2NIVEL.;
FORMAT AUTO_28_1 $TSiNo.;
FORMAT AUTO_28_2 $T1NIVEL.;
FORMAT AUTO_28_3 $TSiNo.;
FORMAT AUTO_28_4 $T2NIVEL.;
FORMAT AUTO_29_1 $TSiNo.;
FORMAT AUTO_29_2 $T1NIVEL.;
FORMAT AUTO_29_3 $TSiNo.;
FORMAT AUTO_29_4 $T2NIVEL.;
FORMAT AUTO_30_1 $TSiNo.;
FORMAT AUTO_30_2 $T1NIVEL.;
FORMAT AUTO_30_3 $TSiNo.;
FORMAT AUTO_30_4 $T2NIVEL.;
FORMAT AUTO_31_1 $TSiNo.;
FORMAT AUTO_31_2 $T1NIVEL.;
FORMAT AUTO_31_3 $TSiNo.;
FORMAT AUTO_31_4 $T2NIVEL.;
FORMAT AUTO_32_1 $TSiNo.;
FORMAT AUTO_32_2 $T1NIVEL.;
FORMAT AUTO_32_3 $TSiNo.;
FORMAT AUTO_32_4 $T2NIVEL.;
FORMAT AUTO_33_1 $TSiNo.;
FORMAT AUTO_33_2 $T1NIVEL.;
FORMAT AUTO_33_3 $TSiNo.;
FORMAT AUTO_33_4 $T2NIVEL.;
FORMAT AUTOC6_1 $TSiNo.;
FORMAT AUTOC6_2 $TSiNo.;

FORMAT AUTOC6_4_1 $TDEFICI.;
FORMAT AUTOC6_4_2 $TDEFICI.;
FORMAT AUTOC6_4_3 $TDEFICI.;
FORMAT AUTOC6_4_4 $TDEFICI.;
FORMAT AUTOC6_5 $TDEFICI.;
FORMAT AUTOC6_6 $T1CAUSA.;
FORMAT AUTOC6_6a $T2CAUSA.;
FORMAT AUTOC6_6b $T3CAUSA.;
FORMAT AUTOC6_6c $T4CAUSA.;
FORMAT AUTOC6_6d $T5CAUSA.;

FORMAT VDOM_34_1 $TSiNo.;
FORMAT VDOM_34_2 $T1NIVEL.;
FORMAT VDOM_34_3 $TSiNo.;
FORMAT VDOM_34_4 $T2NIVEL.;
FORMAT VDOM_35_1 $TSiNo.;
FORMAT VDOM_35_2 $T1NIVEL.;
FORMAT VDOM_35_3 $TSiNo.;
FORMAT VDOM_35_4 $T2NIVEL.;
FORMAT VDOM_36_1 $TSiNo.;
FORMAT VDOM_36_2 $T1NIVEL.;
FORMAT VDOM_36_3 $TSiNo.;
FORMAT VDOM_36_4 $T2NIVEL.;
FORMAT VDOMC7_1 $TSiNo.;
FORMAT VDOMC7_2 $TSiNo.;

FORMAT VDOMC7_4_1 $TDEFICI.;
FORMAT VDOMC7_4_2 $TDEFICI.;
FORMAT VDOMC7_4_3 $TDEFICI.;
FORMAT VDOMC7_4_4 $TDEFICI.;
FORMAT VDOMC7_5 $TDEFICI.;
FORMAT VDOMC7_6 $T1CAUSA.;
FORMAT VDOMC7_6a $T2CAUSA.;
FORMAT VDOMC7_6b $T3CAUSA.;
FORMAT VDOMC7_6c $T4CAUSA.;
FORMAT VDOMC7_6d $T5CAUSA.;

FORMAT RELA_37_1 $TSiNo.;
FORMAT RELA_37_2 $T1NIVEL.;
FORMAT RELA_38_1 $TSiNo.;
FORMAT RELA_38_2 $T1NIVEL.;
FORMAT RELA_39_1 $TSiNo.;
FORMAT RELA_39_2 $T1NIVEL.;
FORMAT RELA_40_1 $TSiNo.;
FORMAT RELA_40_2 $T1NIVEL.;
FORMAT RELA_41_1 $TSiNo.;
FORMAT RELA_41_2 $T1NIVEL.;

FORMAT RELAC8_2_1 $TDEFICI.;
FORMAT RELAC8_2_2 $TDEFICI.;
FORMAT RELAC8_2_3 $TDEFICI.;
FORMAT RELAC8_2_4 $TDEFICI.;
FORMAT RELAC8_3 $TDEFICI.;
FORMAT RELAC8_4 $T1CAUSA.;
FORMAT RELAC8_4a $T2CAUSA.;
FORMAT RELAC8_4b $T3CAUSA.;
FORMAT RELAC8_4c $T4CAUSA.;
FORMAT RELAC8_4d $T5CAUSA.;

FORMAT D_1 $TSALUD.;
FORMAT D_2_1 $TSiNo.;
FORMAT D_2_2 $TSiNo.;
FORMAT D_2_3 $TSiNo.;
FORMAT D_2_4 $TSiNo.;
FORMAT D_2_5 $TSiNo.;
FORMAT D_2_6 $TSiNo.;
FORMAT D_2_7 $TSiNo.;
FORMAT D_2_8 $TSiNo.;
FORMAT D_2_9 $TSiNo.;
FORMAT D_2_10 $TSiNo.;
FORMAT D_2_11 $TSiNo.;
FORMAT D_2_12 $TSiNo.;
FORMAT D_2_13 $TSiNo.;
FORMAT D_2_14 $TSiNo.;
FORMAT D_2_15 $TSiNo.;
FORMAT D_2_16 $TSiNo.;
FORMAT D_2_17 $TSiNo.;
FORMAT D_2_18 $TSiNo.;
FORMAT D_2_19 $TSiNo.;
FORMAT D_2_20 $TSiNo.;
FORMAT D_2_21 $TSiNo.;
FORMAT D_2_22 $TSiNo.;
FORMAT D_2_23 $TSiNo.;
FORMAT D_2_24 $TSiNo.;
FORMAT D_2_25 $TSiNo.;
FORMAT D_2_26 $TSiNo.;
FORMAT D_2_27 $TSiNo.;
FORMAT D_2_28 $TSiNo.;
FORMAT D_3_1_a $TSiNo.;
FORMAT D_3_1_b $TSiNo.;
FORMAT D_3_1_c $TSiNo.;
FORMAT D_3_1_d $TSiNo.;
FORMAT D_3_2_a $TSiNo.;
FORMAT D_3_2_b $TSiNo.;
FORMAT D_3_2_c $TSiNo.;
FORMAT D_3_2_d $TSiNo.;
FORMAT D_3_3_a $TSiNo.;
FORMAT D_3_3_b $TSiNo.;
FORMAT D_3_3_c $TSiNo.;
FORMAT D_3_3_d $TSiNo.;
FORMAT D_3_4_a $TSiNo.;
FORMAT D_3_4_b $TSiNo.;
FORMAT D_3_4_c $TSiNo.;
FORMAT D_3_4_d $TSiNo.;
FORMAT D_3_5_a $TSiNo.;
FORMAT D_3_5_b $TSiNo.;
FORMAT D_3_5_c $TSiNo.;
FORMAT D_3_5_d $TSiNo.;
FORMAT D_3_6_a $TSiNo.;
FORMAT D_3_6_b $TSiNo.;
FORMAT D_3_6_c $TSiNo.;
FORMAT D_3_6_d $TSiNo.;
FORMAT D_3_7_a $TSiNo.;
FORMAT D_3_7_b $TSiNo.;
FORMAT D_3_7_c $TSiNo.;
FORMAT D_3_7_d $TSiNo.;
FORMAT D_3_8_a $TSiNo.;
FORMAT D_3_8_b $TSiNo.;
FORMAT D_3_8_c $TSiNo.;
FORMAT D_3_8_d $TSiNo.;
FORMAT D_4_1_a $TSiNo.;
FORMAT D_4_1_b $TSiNo.;
FORMAT D_4_1_c $TSiNo.;
FORMAT D_4_1_d $TSiNo.;
FORMAT D_4_1_e $TSiNo.;
FORMAT D_4_1_f $TSiNo.;
FORMAT D_4_2_a $TSiNo.;
FORMAT D_4_2_b $TSiNo.;
FORMAT D_4_2_c $TSiNo.;
FORMAT D_4_2_d $TSiNo.;
FORMAT D_4_2_e $TSiNo.;
FORMAT D_4_2_f $TSiNo.;
FORMAT D_4_3_a $TSiNo.;
FORMAT D_4_3_b $TSiNo.;
FORMAT D_4_3_c $TSiNo.;
FORMAT D_4_3_d $TSiNo.;
FORMAT D_4_3_e $TSiNo.;
FORMAT D_4_3_f $TSiNo.;
FORMAT D_4_4_a $TSiNo.;
FORMAT D_4_4_b $TSiNo.;
FORMAT D_4_4_c $TSiNo.;
FORMAT D_4_4_d $TSiNo.;
FORMAT D_4_4_e $TSiNo.;
FORMAT D_4_4_f $TSiNo.;
FORMAT D_4_5_a $TSiNo.;
FORMAT D_4_5_b $TSiNo.;
FORMAT D_4_5_c $TSiNo.;
FORMAT D_4_5_d $TSiNo.;
FORMAT D_4_5_e $TSiNo.;
FORMAT D_4_5_f $TSiNo.;
FORMAT D_4_6_a $TSiNo.;
FORMAT D_4_6_b $TSiNo.;
FORMAT D_4_6_c $TSiNo.;
FORMAT D_4_6_d $TSiNo.;
FORMAT D_4_6_e $TSiNo.;
FORMAT D_4_6_f $TSiNo.;
FORMAT D_4_7_a $TSiNo.;
FORMAT D_4_7_b $TSiNo.;
FORMAT D_4_7_c $TSiNo.;
FORMAT D_4_7_d $TSiNo.;
FORMAT D_4_7_e $TSiNo.;
FORMAT D_4_7_f $TSiNo.;
FORMAT D_4_8_a $TSiNo.;
FORMAT D_4_8_b $TSiNo.;
FORMAT D_4_8_c $TSiNo.;
FORMAT D_4_8_d $TSiNo.;
FORMAT D_4_8_e $TSiNo.;
FORMAT D_4_8_f $TSiNo.;
FORMAT D_5 $TDISCRI.;
FORMAT D_6_1 $TSiNo.;
FORMAT D_6_2 $TSiNo.;
FORMAT E_1_1_a $TSiNo.;
FORMAT E_1_1_b $TSiNo.;
FORMAT E_1_1_c $TSiNo.;
FORMAT E_1_1_d $TSiNo.;
FORMAT E_1_2_a $TSiNo.;
FORMAT E_1_2_b $TSiNo.;
FORMAT E_1_2_c $TSiNo.;
FORMAT E_1_2_d $TSiNo.;
FORMAT E_1_3_a $TSiNo.;
FORMAT E_1_3_b $TSiNo.;
FORMAT E_1_3_c $TSiNo.;
FORMAT E_1_3_d $TSiNo.;
FORMAT E_1_4_a $TSiNo.;
FORMAT E_1_4_b $TSiNo.;
FORMAT E_1_4_c $TSiNo.;
FORMAT E_1_4_d $TSiNo.;
FORMAT E_1_5_a $TSiNo.;
FORMAT E_1_5_b $TSiNo.;
FORMAT E_1_5_c $TSiNo.;
FORMAT E_1_5_d $TSiNo.;
FORMAT E_1_6_a $TSiNo.;
FORMAT E_1_6_b $TSiNo.;
FORMAT E_1_6_c $TSiNo.;
FORMAT E_1_6_d $TSiNo.;
FORMAT E_1_7_a $TSiNo.;
FORMAT E_1_7_b $TSiNo.;
FORMAT E_1_7_c $TSiNo.;
FORMAT E_1_7_d $TSiNo.;
FORMAT E_1_8_a $TSiNo.;
FORMAT E_1_8_b $TSiNo.;
FORMAT E_1_8_c $TSiNo.;
FORMAT E_1_8_d $TSiNo.;
FORMAT E_2_1_a $TSiNo.;
FORMAT E_2_1_b $TSiNo.;
FORMAT E_2_1_c $TSiNo.;
FORMAT E_2_1_d $TSiNo.;
FORMAT E_2_1_e $TSiNo.;
FORMAT E_2_1_f $TSiNo.;
FORMAT E_2_2_a $TSiNo.;
FORMAT E_2_2_b $TSiNo.;
FORMAT E_2_2_c $TSiNo.;
FORMAT E_2_2_d $TSiNo.;
FORMAT E_2_2_e $TSiNo.;
FORMAT E_2_2_f $TSiNo.;
FORMAT E_2_3_a $TSiNo.;
FORMAT E_2_3_b $TSiNo.;
FORMAT E_2_3_c $TSiNo.;
FORMAT E_2_3_d $TSiNo.;
FORMAT E_2_3_e $TSiNo.;
FORMAT E_2_3_f $TSiNo.;
FORMAT E_2_4_a $TSiNo.;
FORMAT E_2_4_b $TSiNo.;
FORMAT E_2_4_c $TSiNo.;
FORMAT E_2_4_d $TSiNo.;
FORMAT E_2_4_e $TSiNo.;
FORMAT E_2_4_f $TSiNo.;
FORMAT E_2_5_a $TSiNo.;
FORMAT E_2_5_b $TSiNo.;
FORMAT E_2_5_c $TSiNo.;
FORMAT E_2_5_d $TSiNo.;
FORMAT E_2_5_e $TSiNo.;
FORMAT E_2_5_f $TSiNo.;
FORMAT E_2_6_a $TSiNo.;
FORMAT E_2_6_b $TSiNo.;
FORMAT E_2_6_c $TSiNo.;
FORMAT E_2_6_d $TSiNo.;
FORMAT E_2_6_e $TSiNo.;
FORMAT E_2_6_f $TSiNo.;
FORMAT E_2_7_a $TSiNo.;
FORMAT E_2_7_b $TSiNo.;
FORMAT E_2_7_c $TSiNo.;
FORMAT E_2_7_d $TSiNo.;
FORMAT E_2_7_e $TSiNo.;
FORMAT E_2_7_f $TSiNo.;
FORMAT E_2_8_a $TSiNo.;
FORMAT E_2_8_b $TSiNo.;
FORMAT E_2_8_c $TSiNo.;
FORMAT E_2_8_d $TSiNo.;
FORMAT E_2_8_e $TSiNo.;
FORMAT E_2_8_f $TSiNo.;
FORMAT E_3 $TSiNo.;
FORMAT E_4_1 $TSiNo.;
FORMAT E_4_2 $TSiNo.;
FORMAT E_4_3 $TSiNo.;
FORMAT E_4_4 $TSiNo.;
FORMAT E_4_5 $TSiNo.;
FORMAT E_5_1 $TSiNo.;
FORMAT E_5_2 $TSiNo.;
FORMAT E_5_3 $TSiNo.;
FORMAT E_6_1 $TSiNo.;
FORMAT E_6_2 $TSiNo.;
FORMAT E_6_3 $TSiNo.;
FORMAT F_1 $TEDUCA.;
FORMAT F_2 $T1MOTIV.;
FORMAT F_3 $TTITULA.;
FORMAT F_4_1 $TSiNo.;
FORMAT F_4_2 $TSiNo.;
FORMAT F_5 $T1ADAP.;
FORMAT F_6 $T2ADAP.;
FORMAT F_7 $TSiNo.;
FORMAT F_8 $T1DIAS.;
FORMAT F_9 $TDISCRI.;
FORMAT F_10_1 $TSiNo.;
FORMAT F_10_2 $TSiNo.;
FORMAT F_10_3 $TSiNo.;
FORMAT F_10_4 $TSiNo.;
FORMAT F_11 $TDISCRI.;
FORMAT F_12 $TSiNo.;
FORMAT F_13 $TSiNo.;
FORMAT F_14 $TESTUDI.;
FORMAT F_15 $TBECA.;
FORMAT F_16 $T1ADAP.;
FORMAT F_17 $T2ADAP.;
FORMAT F_18 $TDISCRI.;
FORMAT F_19_1 $TSiNo.;
FORMAT F_19_2 $TSiNo.;
FORMAT F_19_3 $TSiNo.;
FORMAT F_19_4 $TSiNo.;
FORMAT F_20 $TDISCRI.;
FORMAT F_21 $TSiNo.;
FORMAT G_0 $TLABOR.;

FORMAT G_2 $TSiNo.;
FORMAT G_3 $TMODALI.;
FORMAT G_4 $TCONTRA.;
FORMAT G_5 $TJORNAD.;
FORMAT G_6 $TSiNo.;
FORMAT G_7 $TTAMANO.;
FORMAT G_8 $TSiNo.;
FORMAT G_9 $TOCUPA.;
FORMAT G_10 $TACTIVI.;
FORMAT G_11_1 $TSiNo.;
FORMAT G_11_2 $TSiNo.;
FORMAT G_11_3 $TSiNo.;
FORMAT G_11_4 $TSiNo.;
FORMAT G_11_5 $TSiNo.;
FORMAT G_11_6 $TSiNo.;
FORMAT G_11_7 $TSiNo.;
FORMAT G_11_8 $TSiNo.;
FORMAT G_12_1 $TSiNo.;
FORMAT G_12_2 $TSiNo.;
FORMAT G_12_3 $TSiNo.;
FORMAT G_12_4 $TSiNo.;
FORMAT G_12_5 $TSiNo.;
FORMAT G_12_6 $TSiNo.;
FORMAT G_12_7 $TSiNo.;
FORMAT G_12_8 $TSiNo.;
FORMAT G_12_9 $TSiNo.;
FORMAT G_13 $T1ADAP.;
FORMAT G_14 $TDISCRI.;
FORMAT G_15_1 $TSiNo.;
FORMAT G_15_2 $TSiNo.;
FORMAT G_15_3 $TSiNo.;
FORMAT G_15_4 $TSiNo.;
FORMAT G_16 $TDISCRI.;
FORMAT G_17 $TSiNo.;
FORMAT G_18 $T2MOTIV.;
FORMAT G_19 $T1TIEMP.;
FORMAT G_20_1 $TSiNo.;
FORMAT G_20_2 $TSiNo.;
FORMAT G_20_3 $TSiNo.;
FORMAT G_20_4 $TSiNo.;
FORMAT G_20_5 $TSiNo.;
FORMAT G_20_6 $TSiNo.;
FORMAT G_20_7 $TSiNo.;
FORMAT G_20_8 $TSiNo.;
FORMAT G_20_9 $TSiNo.;
FORMAT G_21 $TSiNo.;
FORMAT G_22_1 $TSiNo.;
FORMAT G_22_2 $TSiNo.;
FORMAT G_22_3 $TSiNo.;
FORMAT G_22_4 $TSiNo.;
FORMAT G_22_5 $TSiNo.;
FORMAT G_22_6 $TSiNo.;
FORMAT G_22_7 $TSiNo.;
FORMAT G_22_8 $TSiNo.;
FORMAT G_22_9 $TSiNo.;
FORMAT G_23 $T1RAZON.;
FORMAT G_24 $TSiNo.;
FORMAT G_25 $T3MOTIV.;
FORMAT G_26 $TSiNo.;
FORMAT G_27 $T2RAZON.;
FORMAT G_28_1 $TSiNo.;
FORMAT G_28_2 $TSiNo.;
FORMAT G_28_3 $TSiNo.;
FORMAT G_28_4 $TSiNo.;
FORMAT G_28_5 $TSiNo.;
FORMAT G_28_6 $TSiNo.;
FORMAT G_28_7 $TSiNo.;
FORMAT G_28_8 $TSiNo.;
FORMAT G_28_9 $TSiNo.;
FORMAT ACTECO $TACTECO.;
FORMAT H_1 $TSiNo.;
FORMAT H_2 $TFRECU.;
FORMAT H_3 $TSiNo.;
FORMAT H_4 $TFRECU.;
FORMAT H_5 $TSiNo.;
FORMAT H_6 $TFRECU.;
FORMAT H_7 $TSiNo.;
FORMAT H_8 $TFRECU.;
FORMAT H_9 $TVALORA.;
FORMAT H_10_1 $TSiNo.;
FORMAT H_10_2 $TSiNo.;
FORMAT H_10_3 $TSiNo.;
FORMAT H_10_4 $TSiNo.;
FORMAT H_10_5 $TSiNo.;
FORMAT H_10_6 $TSiNo.;
FORMAT H_10_7 $TSiNo.;
FORMAT H_10_8 $TSiNo.;
FORMAT H_10_9 $TSiNo.;
FORMAT H_10_10 $TSiNo.;
FORMAT H_10_11 $TSiNo.;
FORMAT H_10_12 $TSiNo.;
FORMAT H_10_13 $TSiNo.;
FORMAT H_10_14 $TSiNo.;
FORMAT H_11 $T3RAZON.;
FORMAT H_12 $TSiNo.;
FORMAT H_13_1 $TSiNo.;
FORMAT H_13_2 $TSiNo.;
FORMAT H_13_3 $TSiNo.;
FORMAT H_13_4 $TSiNo.;
FORMAT H_13_5 $TSiNo.;
FORMAT H_13_6 $TSiNo.;
FORMAT H_13_7 $TSiNo.;
FORMAT H_13_8 $TSiNo.;
FORMAT H_13_9 $TSiNo.;
FORMAT H_13_10 $TSiNo.;
FORMAT H_13_11 $TSiNo.;
FORMAT H_13_12 $TSiNo.;
FORMAT H_13_13 $TSiNo.;
FORMAT H_14 $TDISCRI.;
FORMAT H_15_1 $TSiNo.;
FORMAT H_15_2 $TSiNo.;
FORMAT H_15_3 $TSiNo.;
FORMAT H_16 $TSiNo.;
FORMAT H_17 $TSATIFA.;
FORMAT H_18 $TSiNo.;
FORMAT H_19 $TSiNo.;
FORMAT H_20 $TDISCRI.;
FORMAT I_1 $TSiNo.;
FORMAT I_2_1 $TSiNo.;
FORMAT I_2_2 $TSiNo.;
FORMAT I_2_3 $TSiNo.;
FORMAT I_3 $TSiNo.;
FORMAT I_3_1 $TSiNo.;
FORMAT I_3_2 $TSiNo.;
FORMAT I_3_3 $TSiNo.;
FORMAT I_4 $TSiNo.;
FORMAT I_5 $T4MOTIV.;
FORMAT I_6 $TSiNo.;
FORMAT I_7_1 $TSiNo.;
FORMAT I_7_2 $TSiNo.;
FORMAT I_7_3 $TSiNo.;
FORMAT I_8 $TSiNo.;
FORMAT I_9_1 $TSiNo.;
FORMAT I_9_2 $TSiNo.;
FORMAT I_9_3 $TSiNo.;
FORMAT I_10 $TSiNo.;
FORMAT I_11_1 $TSiNo.;
FORMAT I_11_2 $TSiNo.;
FORMAT I_11_3 $TSiNo.;
FORMAT I_11_4 $TSiNo.;
FORMAT I_12_1 $TSiNo.;
FORMAT I_12_2 $TSiNo.;
FORMAT I_12_3 $TSiNo.;
FORMAT I_12_4 $TSiNo.;
FORMAT I_13 $TDISCRI.;
FORMAT I_14_1 $TSiNo.;
FORMAT I_14_2 $TSiNo.;
FORMAT I_14_3 $TSiNo.;
FORMAT I_15 $TSiNo.;
FORMAT I_16_1 $TSiNo.;
FORMAT I_16_2 $TSiNo.;
FORMAT I_16_3 $TSiNo.;
FORMAT I_16_4 $TSiNo.;
FORMAT I_16_5 $TSiNo.;
FORMAT I_16_6 $TSiNo.;
FORMAT I_16_7 $TSiNo.;
FORMAT I_17 $TMEJORA.;
FORMAT J_1 $TSiNo.;
FORMAT J_2_1 $TSiNo.;
FORMAT J_2_2 $TSiNo.;
FORMAT J_2_3 $TSiNo.;
FORMAT J_2_4 $TSiNo.;
FORMAT J_2_5 $TSiNo.;
FORMAT J_2_6 $TSiNo.;
FORMAT J_3 $TSiNo.;
FORMAT J_4_1 $TSiNo.;
FORMAT J_4_2 $TSiNo.;
FORMAT J_4_3 $TSiNo.;
FORMAT J_4_4 $TSiNo.;
FORMAT J_4_5 $TSiNo.;
FORMAT J_4_6 $TSiNo.;
FORMAT J_4_7 $TSiNo.;
FORMAT J_4_8 $TSiNo.;




FORMAT J_6 $TSiNo.;
FORMAT J_7 $TPERSON.;
FORMAT J_8 $TSiNo.;

FORMAT J_10 $TSiNo.;
FORMAT J_12 $TSiNo.;
FORMAT K_1_01 $TSiNo.;
FORMAT K_1_02 $TSiNo.;
FORMAT K_1_03 $TSiNo.;
FORMAT K_1_04 $TSiNo.;
FORMAT K_1_05 $TSiNo.;
FORMAT K_1_06 $TSiNo.;
FORMAT K_1_07 $TSiNo.;
FORMAT K_1_08 $TSiNo.;
FORMAT K_1_09 $TSiNo.;
FORMAT K_1_10 $TSiNo.;
FORMAT K_1_11 $TSiNo.;
FORMAT K_1_12 $TSiNo.;
FORMAT K_1_13 $TSiNo.;
FORMAT K_1_14 $TSiNo.;
FORMAT K_2 $TGASTO.;

FORMAT INFORM $TSiNo.;
FORMAT PROXY2 $T2PROXY.;
FORMAT TIPO_ENT $TENTREV.;
FORMAT B_1 $T6SEXO.;
FORMAT B_3 $TECIVIL.;
FORMAT B_4 $TESTUD.;
FORMAT B_5 $TNACIO.;
FORMAT RELACT_CUID $T2ACTI.;
FORMAT B_7 $T2TIEMP.;
FORMAT B_8_1 $TSiNo.;
FORMAT B_8_2 $TSiNo.;
FORMAT B_8_3 $TSiNo.;
FORMAT B_8_4 $TSiNo.;
FORMAT B_8_5 $TSiNo.;
FORMAT B_8_6 $TSiNo.;
FORMAT B_8_7 $TSiNo.;
FORMAT B_8_8 $TSiNo.;
FORMAT B_8_9 $TSiNo.;
FORMAT B_8_10 $TSiNo.;
FORMAT B_8_11 $TSiNo.;
FORMAT B_8_12 $TSiNo.;
FORMAT B_9 $T2DIAS.;

FORMAT B_11_1 $TSiNo.;
FORMAT B_11_2 $TSiNo.;
FORMAT B_11_3 $TSiNo.;
FORMAT B_11_4 $TSiNo.;
FORMAT B_11_5 $TSiNo.;
FORMAT B_12_1 $TSiNo.;
FORMAT B_12_2 $TSiNo.;
FORMAT B_12_3 $TSiNo.;
FORMAT B_12_4 $TSiNo.;
FORMAT B_12_5 $TSiNo.;
FORMAT B_13_1 $TSiNo.;
FORMAT B_13_2 $TSiNo.;
FORMAT B_13_3 $TSiNo.;
FORMAT B_13_4 $TSiNo.;
FORMAT B_13_5 $TSiNo.;
FORMAT B_14_1 $TSiNo.;
FORMAT B_14_2 $TSiNo.;
FORMAT B_14_3 $TSiNo.;
FORMAT B_14_4 $TSiNo.;
FORMAT B_15_1 $TSiNo.;
FORMAT B_15_2 $TSiNo.;
FORMAT B_15_3 $TSiNo.;
FORMAT B_15_4 $TSiNo.;
FORMAT B_15_5 $TSiNo.;
FORMAT B_15_6 $TSiNo.;
FORMAT B_15_7 $TSiNo.;
FORMAT B_15_8 $TSiNo.;
FORMAT B_15_9 $TSiNo.;
FORMAT B_15_10 $TSiNo.;
FORMAT B_16 $TSiNo.;





RUN;
/* FIN PROGRAMA: Microdatos en SAS: EDAD_periodo.sas*/
