/**********************************************************************************************************************					
Instituto Nacional de Estadstica (INE) www.ine.es					
***********************************************************************************************************************					
					
DESCRIPCIN:					
Este programa genera un fichero SAS con formatos, partiendo de un fichero sin ellos.					
					
Consta de las siguientes partes:					
	* 1. Definir la librera de trabajo --> Libname				
	* 2. Definicin de formatos --> PROC FORMAT				
	* 3. Vincular formatos a la base de datos --> PASO data				
					
 Entrada:                                                           					
     - Fichero SAS sin formatos: 	 EDADhogar_2020.sas7bdat				
 Salida:                                                           					
     - Fichero SAS con formatos: 	 EDADhogar_2020_conFormato.sas7bdat				
					
Donde:					
	* Operacin: Encuesta de Discapacidad, Autonoma personal y Situaciones de dependencia(EDADhogar)
	* Periodo: 2020
					
************************************************************************************************************************/					
		
/* Directorio de trabajo para la operacin estadstica */
*%let siglas_periodo = EDADhogar_2020;
*%let conFormato = _conFormato;
					
/*1) Definir la librera de trabajo: introducir el directorio que desee como librera					
(se da como ejemplo 'C:\Mis resultados'), y copiar en ese directorio el fichero sas "EDADhogar_2018.sas7bdat"*/					
					
*libname ROutput 'C:\Mis resultados';	

options fmtsearch = (ROutput ROutput.cat1);

* 2) DEFINICIN DE FORMATOS;
PROC FORMAT LIBRARY=ROutput.cat1;

value $TCCAA

"01"="Andaluca"
"02"="Aragn"
"03"="Principado de Asturias"
"04"="Illes Balears"
"05"="Canarias"
"06"="Cantabria"
"07"="Castilla y Len"
"08"="Castilla - La Mancha"
"09"="Catalua"
"10"="Comunitat Valenciana"
"11"="Extremadura"
"12"="Galicia"
"13"="Comunidad de Madrid"
"14"="Regin de Murcia"
"15"="Comunidad Foral de Navarra"
"16"="Pas Vasco"
"17"="La Rioja"
"18"="Ceuta"
"19"="Melilla"
;
value $TPHOG

"1"="Hogar unipersonal"
"2"="Padre o madre solo/a que convive con algn hijo"
"3"="Pareja sin hijos que convivan en el hogar"
"4"="Pareja con hijos que convivan en el hogar"
"5"="Otro tipo de hogar"
;
;
value $TLIMIT

"1"="S, gravemente limitado"
"2"="S, limitado pero no gravemente"
"3"="No, nada limitado"
"9"="NC"
;
value $TCERTI

"1"="Menos del 25%"
"2"="25% al 32%"
"3"="33% al 44%"
"4"="45% al 64%"
"5"="65% al 74%"
"6"="Mayor/igual al 75%"
"7"="Ninguno"
"9"="NC"
;
value $TPENSIO

" "="Menores de 16 aos"
"1"="De la Seguridad social: total, absoluta o gran invalidez"
"2"="De la Seguridad social: invalidez parcial"
"3"="De clases pasivas incapacidad permanente"
"4"="Otra pensin de incapacidad permanente"
"5"="Ninguna"
"9"="NC"
;
value $TDEPEN

"1"="Grado I"
"2"="Grado II"
"3"="Grado III"
"4"="Ninguna"
"9"="NC"
;
value $TMUNI

"1"="Capital de provincia y municipios de ms de 100.000 habitantes"
"2"="De 50.000 a 100.000 habitantes"
"3"="De 20.000 a menos de 50.000 habitantes"
"4"="De 10.000 a menos de 20.000 habitantes"
"5"="Menos de 10.000 habitantes"
;
value $TINGRES

"  "="Ninguna fuente de ingresos"
"01"="Menos de 650"
"02"="De 650 a menos de 880"
"03"="De 880 a menos de 1.150"
"04"="De 1.150 a menos de 1.400"
"05"="De 1.400 a menos de 1.670"
"06"="De 1.670 a menos de 2.000"
"07"="De 2.000 a menos de 2.400"
"08"="De 2.400 a menos de 3.000"
"09"="De 3.000 a menos de 3.900"
"10"="De 3.900 en adelante"
"99"="NC"
;

value $TSEXO

"1"="Hombre"
"2"="Mujer"
;
value $TSINO

"1"="S"
"6"="No"
"9"="NC"
;
value $TNACIO

"1"="Espaola"
"2"="Extranjera"
"3"="Espaola y otra"
;
value $TECIVIL

"1"="Soltero"
"2"="Casado"
"3"="Viudo"
"4"="Separado legalmente"
"5"="Divorciado"
"9"="NC"
;
value $TESTUD

"  "="Menores de 10 aos"
"01"="No sabe leer ni escribir"
"02"="Estudios primarios incompletos"
"03"="Estudios primarios o equivalentes"
"04"="Educacin secundaria de 1 etapa"
"05"="Estudios de bachillerato"
"06"="Enseanza profesional de grado medio"
"07"="Enseanzas profesionales superiores"
"08"="Estudios universitarios o equivalentes"
"99"="NC"
;




* 3) VINCULAR FORMATOS A LA BASE DE DATOS;

	DATA ROutput.&siglas_periodo.&conFormato;
		set ROutput.&siglas_periodo;

FORMAT CCAA $TCCAA.;
FORMAT TMUNI $TMUNI.;
FORMAT TIPOHOG $TPHOG.;
FORMAT INFOR_HOG $TSINO.;
FORMAT SEXO $TSEXO.;
FORMAT NACIO $TNACIO.;
FORMAT ECIVIL $TECIVIL.;
FORMAT ESTUDIO $TESTUD.;
FORMAT LIMIT_D $TLIMIT.;
FORMAT CERTI_D $TCERTI.;
FORMAT PENSION_D $TPENSIO.;
FORMAT DEPEN_D $TDEPEN.;
FORMAT DISLIM $TSINO.;
FORMAT ESC_VI $TSINO.;
FORMAT DUCHA $TSINO.;
FORMAT VATER $TSINO.;
FORMAT COCINA $TSINO.;
FORMAT FRIGO $TSINO.;
FORMAT LAVAD $TSINO.;
FORMAT LAVAV $TSINO.;
FORMAT MICROO $TSINO.;
FORMAT TELEV $TSINO.;
FORMAT TELEF_FIJ $TSINO.;
FORMAT TELEF_MOV $TSINO.;
FORMAT ORDENAD $TSINO.;
FORMAT INTERN $TSINO.;
FORMAT TABLET $TSINO.;
FORMAT CALEFAC $TSINO.;
FORMAT AIREAC $TSINO.;
FORMAT AUTO $TSINO.;
FORMAT GOTERA $TSINO.;
FORMAT LUZ $TSINO.;
FORMAT RUIDO $TSINO.;
FORMAT CONTAM $TSINO.;
FORMAT DELINC $TSINO.;
FORMAT IN_TRAB $TSINO.;
FORMAT IN_PENS $TSINO.;
FORMAT IN_SUBDE $TSINO.;
FORMAT IN_OTROS $TSINO.;
FORMAT INGRESO $TINGRES.;



RUN;
/* FIN PROGRAMA: Microdatos en SAS: EDAD_periodo.sas*/
