/**********************************************************************************************************************					
Instituto Nacional de Estadística (INE) www.ine.es					
***********************************************************************************************************************					
					
DESCRIPCIÃ“N:					
Este programa genera un fichero SAS con formatos, partiendo de un fichero sin ellos.					
					
Consta de las siguientes partes:					
	* 1. Definir la librería de trabajo --> Libname				
	* 2. Definición de formatos --> PROC FORMAT				
	* 3. Vincular formatos a la base de datos --> PASO data				
					
 Entrada:                                                           					
     - Fichero SAS sin formatos: 	 EDADlimitaciones_2020.sas7bdat				
 Salida:                                                           					
     - Fichero SAS con formatos: 	 EDADlimitaciones_2020_conFormato.sas7bdat				
					
Donde:					
	* Operación: Encuesta de Discapacidad, AutonomÃ­a personal y Situaciones de dependencia(EDADlimitaciones)
	* Periodo: 2020
					
************************************************************************************************************************/					
		
/* Directorio de trabajo para la operación estadí­stica */
*%let siglas_periodo = EDADhogar_2020;
*%let conFormato = _conFormato;
					
/*1) Definir la librería de trabajo: introducir el directorio que desee como librerí­a					
(se da como ejemplo 'C:\Mis resultados'), y copiar en ese directorio el fichero sas "EDADlimitaciones_2018.sas7bdat"*/					
					
*libname ROutput 'C:\Mis resultados';	

options fmtsearch = (ROutput ROutput.cat1);

* 2) DEFINICIÓN DE FORMATOS;
PROC FORMAT LIBRARY=ROutput.cat1;

value $TCCAA

"01"="Andaluca"
"02"="Aragn"
"03"="Principado de Asturias"
"04"="Illes Balears"
"05"="Canarias"
"06"="Cantabria"
"07"="Castilla y Len"
"08"="Castilla - La Mancha"
"09"="Catalua"
"10"="Comunitat Valenciana"
"11"="Extremadura"
"12"="Galicia"
"13"="Comunidad de Madrid"
"14"="Regin de Murcia"
"15"="Comunidad Foral de Navarra"
"16"="Pas Vasco"
"17"="La Rioja"
"18"="Ceuta"
"19"="Melilla"
;
value $TMUNIC

"1"="Capital de provincia y municipios de ms de 100.000 habitantes"
"2"="De 50.000 a 100.000 habitantes"
"3"="De 20.000 a menos de 50.000 habitantes"
"4"="De 10.000 a menos de 20.000 habitantes"
"5"="Menos de 10.000 habitantes"
;
value $TRELAC

"1"="Padre/madre"
"2"="Tutor/a"
"3"="Hermano/hermana"
"4"="Abuelo/a"
"5"="Otros familiares"
"6"="Servicios sociales"
"7"="Persona empleada en el hogar"
"8"="Otra relacin"
"9"="NC"
;
value $TETIOLO

"1"="Un problema congnito"
"2"="Problemas en el parto"
"3"="Un accidente"
"4"="Una enfermedad"
"5"="Otras causas"
"9"="NC"
""="blanco"
;
value $T1CUIDA

"01"="Madre"
"02"="Padre"
"03"="Hermano/a"
"04"="Abuelo/a"
"05"="Otro familiar"
"06"="Una persona empleada en el hogar"
"07"="Un professional socio-sanitario"
"08"="Un asistente personal"
"09"="Otra persona distinta a las anteriores"
"99"="NC"
;
value $T2CUIDA

"1"="Profesional socio sanitario"
"2"="Otra persona (familiar, personal no socio sanitario,)"
"3"="Ambos"
"9"="NC"
;
value $TPROXY

"1"="Ausencia prolongada"
"2"="Discapacidad o enfermedad grave que le impide contestar"
"3"="Desconocimiento del idioma"
;
value $TENTREV

"1"="Personal"
"6"="Telefnica"
;
value $T2ACTI

"1"="Trabajando"
"2"="No trabaja"
"3"="Jubilado/a, prejubilado/a, retirado/a de una actividad econmica previa"
"4"="Incapacitado/a para trabajar"
"9"="NC"
;
value $TTIEMP

"1"="Menos de 1 ao"
"2"="De 1 hasta 2 aos"
"3"="De 2 hasta 4 aos"
"4"="De 4 hasta 8 aos"
"5"="8 y ms aos"
"9"="NC"
;
value $T2DIAS

"0"="Menos de 1 da"
"7"="Los 7 das de la semana"
"9"="NC"
;
*Tablas2....;
value $TDEFICI

"01"="Deficiencias mentales"
"02"="Deficiencias visuales"
"03"="Deficiencias del odo"
"04"="Deficiencias del lenguaje, habla y voz"
"53"="Deficiencias osteoarticular. Extremidades superiores"
"54"="Deficiencias osteoarticular. Extremidades inferiores"
"59"="Deficiencias osteoarticular. Otras deficiencias osteoarticulares"
"06"="Deficiencias del sistema nervioso"
"07"="Deficiencias viscerales"
"08"="Otras deficiencias"
"99"="No sabe/No contesta"
""="blanco"
;
value $T2SEXO

"1"="Nio"
"2"="Nia"
;
value $TSINO

"1"="S"
"6"="No"
"9"="NC"
;
*Tablas3;
value $THORAS

"00"="Menos de 1 hora"
"99"="NC"
;




* 3) VINCULAR FORMATOS A LA BASE DE DATOS;

	DATA ROutput.&siglas_periodo.&conFormato;
		set ROutput.&siglas_periodo;

FORMAT CCAA $TCCAA.;
FORMAT TMUNI $TMUNIC.;

FORMAT SEXO $T2SEXO.;

FORMAT INFOR_RELAC $TRELAC.;
FORMAT INFOR_HOG $TSINO.;
FORMAT A_01 $TSINO.;
FORMAT A_02 $TSINO.;
FORMAT VISI_03 $TSINO.;
FORMAT DEFI_04 $TDEFICI.;
FORMAT ETIOLO_05 $TETIOLO.;
FORMAT AUDI_06 $TSINO.;
FORMAT DEFI_07 $TDEFICI.;
FORMAT ETIOLO_08 $TETIOLO.;
FORMAT MOVI_09 $TSINO.;
FORMAT MOVI_10 $TSINO.;
FORMAT DEFI_11 $TDEFICI.;
FORMAT ETIOLO_12 $TETIOLO.;
FORMAT COMU_13 $TSINO.;
FORMAT DEFI_14 $TDEFICI.;
FORMAT ETIOLO_15 $TETIOLO.;
FORMAT APRE_16 $TSINO.;
FORMAT DEFI_17 $TDEFICI.;
FORMAT ETIOLO_18 $TETIOLO.;
FORMAT RELA_19 $TSINO.;
FORMAT DEFI_20 $TDEFICI.;
FORMAT ETIOLO_21 $TETIOLO.;
FORMAT CUI_MENOR_HOG $TSINO.;
FORMAT PERSHOG_CUI1 $TSINO.;
FORMAT PERSHOG_CUI2 $TSINO.;
FORMAT PERSHOG_CUI3 $TSINO.;
FORMAT PERSHOG_CUI4 $TSINO.;
FORMAT PERSHOG_CUI5 $TSINO.;
FORMAT PERSHOG_CUI6 $TSINO.;
FORMAT CUI_MENOR_NOHOG $TSINO.;
FORMAT PERSNOHOG_CUI1 $TSINO.;
FORMAT PERSNOHOG_CUI2 $TSINO.;
FORMAT PERSNOHOG_CUI3 $TSINO.;
FORMAT PERSNOHOG_CUI4 $TSINO.;
FORMAT PERSNOHOG_CUI5 $TSINO.;
FORMAT PERSNOHOG_CUI6 $TSINO.;
FORMAT PERSNOHOG_CUI7 $TSINO.;
FORMAT PERSNOHOG_CUI8 $TSINO.;
FORMAT HORAS_CUI $THORAS.;
FORMAT SATISF_CUI $TSINO.;
FORMAT CUI_PRAL $T1CUIDA.;
FORMAT CUI_PRAL_HOG $TSINO.;

FORMAT CUI_NECESIDAD $TSINO.;
FORMAT CUI_QUIEN $T2CUIDA.;
FORMAT INFORM $TSINO.;
FORMAT PROXY $TPROXY.;
FORMAT TIPO_ENT $TENTREV.;
FORMAT RELACT_CUID $T2ACTI.;
FORMAT B_7 $TTIEMP.;
FORMAT B_8_1 $TSINO.;
FORMAT B_8_2 $TSINO.;
FORMAT B_8_3 $TSINO.;
FORMAT B_8_4 $TSINO.;
FORMAT B_8_5 $TSINO.;
FORMAT B_8_6 $TSINO.;
FORMAT B_8_7 $TSINO.;
FORMAT B_8_8 $TSINO.;
FORMAT B_8_9 $TSINO.;
FORMAT B_8_10 $TSINO.;
FORMAT B_8_11 $TSINO.;
FORMAT B_8_12 $TSINO.;
FORMAT B_9 $T2DIAS.;
FORMAT B_10 THORAS.;
FORMAT B_11_1 $TSINO.;
FORMAT B_11_2 $TSINO.;
FORMAT B_11_3 $TSINO.;
FORMAT B_11_4 $TSINO.;
FORMAT B_11_5 $TSINO.;
FORMAT B_12_1 $TSINO.;
FORMAT B_12_2 $TSINO.;
FORMAT B_12_3 $TSINO.;
FORMAT B_12_4 $TSINO.;
FORMAT B_12_5 $TSINO.;
FORMAT B_13_1 $TSINO.;
FORMAT B_13_2 $TSINO.;
FORMAT B_13_3 $TSINO.;
FORMAT B_13_4 $TSINO.;
FORMAT B_13_5 $TSINO.;
FORMAT B_14_1 $TSINO.;
FORMAT B_14_2 $TSINO.;
FORMAT B_14_3 $TSINO.;
FORMAT B_14_4 $TSINO.;
FORMAT B_15_1 $TSINO.;
FORMAT B_15_2 $TSINO.;
FORMAT B_15_3 $TSINO.;
FORMAT B_15_4 $TSINO.;
FORMAT B_15_5 $TSINO.;
FORMAT B_15_6 $TSINO.;
FORMAT B_15_7 $TSINO.;
FORMAT B_15_8 $TSINO.;
FORMAT B_15_9 $TSINO.;
FORMAT B_15_10 $TSINO.;
FORMAT B_16 $TSINO.;


RUN;
/* FIN PROGRAMA: Microdatos en SAS: EDAD_periodo.sas*/
