/**********************************************************************************************************************		
Instituto Nacional de Estadstica (INE) www.ine.es		
***********************************************************************************************************************		
		
DESCRIPCIN:		
Este programa genera un fichero SAS con formatos, partiendo de un fichero sin ellos.		
		
Consta de las siguientes partes:		
	* 1. Definir la librera de trabajo --> Libname	
	* 2. Definicin de formatos --> PROC FORMAT	
	* 3. Vincular formatos a la base de datos --> PASO data	
		
 Entrada:                                                           		
     - Fichero SAS sin formatos: 	 EES_cuatrienal_2006.sas7bdat	
 Salida:                                                           		
     - Fichero SAS con formatos: 	 EES_cuatrienal_2006_conFormato.sas7bdat	
		
Donde:		
	* Operacin: Encuesta Cuatrienal de Estructura Salarial _EES_cuatrienal	
	* Periodo: 2006	
		
************************************************************************************************************************/		
		
/*1) Definir la librera de trabajo: introducir el directorio que desee como librera		
(se da como ejemplo 'C:\Mis resultados'), y copiar en ese directorio el fichero sas "EES_cuatrienal_2006.sas7bdat"*/		
		
libname ROutput 'C:\Mis resultados';		

options fmtsearch = (ROutput ROutput.cat1);

* 2) DEFINICIN DE FORMATOS;
PROC FORMAT LIBRARY=ROutput.cat1;
value $TNUTS

"1"="NOROESTE"
"2"="NORESTE"
"3"="COMUNIDAD DE MADRID"
"4"="CENTRO"
"5"="ESTE"
"6"="SUR"
"7"="CANARIAS"
;
value $TTrabaj

"0"="INCLUYE TODOS LOS ESTRATOS"
"1"="DE 1 A 49 TRABAJADORES"
"2"="DE 50 A 199 TRABAJADORES"
"3"="200 Y MS TRABAJADORES"
"4"="INCLUYE ESTRATO 2 Y 3"
;
value $TContro

"1"="PUBLICO"
"2"="PRIVADO"
;
value $TMercad

"1"="LOCAL O REGIONAL"
"2"="NACIONAL"
"3"="UNIN EUROPEA"
"4"="MUNDIAL"
;
value $TRegula

"1"="ESTATAL SECTORIAL"
"2"="SECTORIAL DE AMBITO INFERIOR (AUTONMICO, PROVINCIAL, COMARCAL...)"
"3"="DE EMPRESA O GRUPO DE EMPRESAS"
"4"="DE CENTRO DE TRABAJO"
"5"="OTRA FORMA DE REGULACIN"
;
value $TSexo

"1"="HOMBRE"
"6"="MUJER"
;
value $TPais

"1"="ESPAA"
"2"="RESTO MUNDO"
;
value $TJornad

"1"="TIEMPO COMPLETO"
"6"="TIEMPO PARCIAL"
;
value $TContra

"1"="DURACION INDEFINIDA"
"2"="DURACION DETERMINADA"
;
value $TSino

"1"="S"
"6"="No"
;
value $TEdad

"01"="MENOS 19 AOS"
"02"="DE 20 A 29"
"03"="DE 30 A 39"
"04"="DE 40 A 49"
"05"="DE 50 A 59"
"06"="MS DE 59"
;
value $TTitula

"1"="Sin estudios"
"2"="Educacin primaria"
"3"="Educacin secundaria I"
"4"="Educacin secundaria II"
"5"="Formacin profesional de grado medio"
"6"="Formacin profesional de grado superior"
"7"="Diplomados universitarios o equivalente"
"8"="Licenciados, ingenieros superiores y doctores."
;
value $TCNAE

"CA00"="10,11,12,13,14"
"DABC"="15,16,17,18,19"
"DDE0"="20,21"
"DE22"="22"
"DFGH"="23,24,25"
"DI26"="26"
"DJ00"="27,28"
"DK29"="29"
"DL00"="30,31,32,33"
"DMN0"="34,35,36,37"
"EE00"="40,41"
"F045"="45"
"GG00"="50,51"
"GG52"="52"
"H055"="55"
"II00"="60,61,62"
"II01"="63,64"
"JJ00"="65,66,67"
"KK00"="70,71,72,73,74"
"MM00"="80"
"NN00"="85"
"OO00"="90,91,92,93"
;


* 3) VINCULAR FORMATOS A LA BASE DE DATOS;
data ROutput.EES_cuatrienal_2006_ConFormato;
	set ROutput.EES_cuatrienal_2006;

FORMAT NUTS1 $TNUTS.;
FORMAT CNACE $TCNAE.;
FORMAT ESTRATO2 $TTrabaj.;
FORMAT CONTROL $TContro.;
FORMAT MERCADO $TMercad.;
FORMAT CONVENIO $TRegula.;
FORMAT SEXO $TSexo.;
FORMAT TIPOPAIS $TPais.;
FORMAT RESPONSA $TSino.;
FORMAT ESTU $TTitula.;
FORMAT TIPOJOR $TJornad.;
FORMAT TC $TContra.;
FORMAT AFECMES $Tsino.;
FORMAT AFECANO $Tsino.;
FORMAT ANOS2 $TEdad.;



RUN;
/* FIN PROGRAMA: Microdatos en SAS: EES_cuatrienal_2006.sas*/
