%% sjs.cls 0.1   2019-08-11    INE_SJS style file
%------------------------------------------------------------------
% Filename: sjs.cls
%
% This documentclass is intended for typesetting articles for the
%
%           Spanish Journal of Statistics.
%
% See http://www.ine.es/completeURL for further details.
%
% Search for ``%%% PART'' to find the main parts of this class file.
%
% The class was developed by David Salgado, from Statistics Spain (INE)
% strongly based on the josis (Journal of Spatial Information Science)
% document class, taken from Overleaf templates for academic articles.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Declare class and load external packages
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Need this version of LaTeX atleast (for ClassWarning commands)
\NeedsTeXFormat{LaTeX2e}[1994/06/01]
\ProvidesClass{sjs}[2019/08/11 v0.1 Spanish Journal of Statistics]


% Load article class and handle options.
\ProcessOptions\relax
\LoadClass[11pt,twoside,A4paper,onecolumn]{article}

% Load required packages
\RequirePackage{palatino}
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{amssymb}
\RequirePackage{graphicx}
\RequirePackage{url}
%\RequirePackage[cross,letter,center]{crop}
\RequirePackage[letter,center]{crop}
%\RequirePackage{geometry}

\RequirePackage{authblk}
\renewcommand{\Affilfont}{\small}

% Load cclicenses package
% Note that this package is included in the josis/latex distribution
%\RequirePackage{cclicenses}


\urlstyle{rm}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% IF macro
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rather than load the whole ifthen package, we'll use the following macro.
%
% Check if the two arguments expand to the same thing
% MAGIC happens in the \edef which expands #1 and #2 completely first
% Mainly used to check equality of strings
\newcommand{\ifex}[2]{%
   \edef\sjs@tmpa{#1}%
   \edef\sjs@tmpb{#2}%
   \ifx\sjs@tmpa\sjs@tmpb
}

  \setlength{\itemsep}{1pt}
  \setlength{\parskip}{0pt}
  \setlength{\parsep}{0pt}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Define the layout of the page
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set page and margin lengths

\RequirePackage[a4paper, top=10mm, includehead, headsep=15mm, headheight=30pt,left=20mm, textwidth=170mm, textheight=225mm, columnsep=18pt, footskip=55pt]{geometry}

\special{papersize=210mm,297mm} % set size for ghostscript


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Values of parameters specific to the journal
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\newcommand\sjs@journalname{Spanish Journal of Statistics}
\newcommand\sjs@journaladdress{http://www.ine.es}

% Initialize properties to default value
\newcommand{\sjs@articletype}{\@empty}
\newcommand{\sjs@year}{\@empty}
\newcommand{\sjs@volume}{\@empty}
\newcommand{\sjs@issue}{\@empty}
\newcommand{\sjs@received}{\@empty}
\newcommand{\sjs@accepted}{\@empty}
\newcommand{\sjs@returned}{\@empty}
\newcommand{\sjs@revised}{\@empty}
\newcommand{\sjs@declaredfirstpage}{\@empty}
\newcommand{\sjs@declaredlastpage}{\@empty}
\newcommand{\sjs@doi}{\@empty}
\newcommand{\sjs@url}{\@empty}


%%% The rest of this part establises the hookds for the \sjsdetails command.
\define@key{sjsdet}{articletype}{\renewcommand{\sjs@articletype}{\textsc{#1}}}
\define@key{sjsdet}{year}{\renewcommand{\sjs@year}{#1}}
\define@key{sjsdet}{volume}{\renewcommand{\sjs@volume}{#1}}
\define@key{sjsdet}{issue}{\renewcommand{\sjs@issue}{#1}}
\define@key{sjsdet}{doi}{\renewcommand{\sjs@doi}{#1}}
\define@key{sjsdet}{received}{\renewcommand{\sjs@received}{#1}}
\define@key{sjsdet}{accepted}{\renewcommand{\sjs@accepted}{#1}}
\define@key{sjsdet}{returned}{\renewcommand{\sjs@returned}{#1}}
\define@key{sjsdet}{revised}{\renewcommand{\sjs@revised}{#1}}
\define@key{sjsdet}{firstpage}{\renewcommand{\sjs@declaredfirstpage}{#1}}
\define@key{sjsdet}{lastpage}{\renewcommand{\sjs@declaredlastpage}{#1}}
    \define@key{sjsdet}{doi}{\renewcommand{\sjs@doi}{#1}}
\define@key{sjsdet}{url}{\renewcommand{\sjs@url}{#1}}

% argument is a comma separated list of the type "volume=6,year=8,..."
% If we have details of section we are interested in, process it
\newcommand{\sjsdetails}[1]{\setkeys{sjsdet}{#1}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Default values for Article META Information
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\sjs@copyrightauthor{\textsc{ine}}
\newcommand\sjs@runningauthor{}
\newcommand\sjs@runningtitle{}

% Define parameter passing functions for author metadata.
\newcommand*{\runningauthor}[1]{%
    \renewcommand\sjs@runningauthor{#1}}
\newcommand*{\runningtitle}[1]{%
    \renewcommand\sjs@runningtitle{#1}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Title page
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Keywords definition
\newcommand{\keywords}[1]{\gdef\@keywords{#1}}
\def\@keywords{\@latex@error{No \noexpand\keywords given}\@ehc}

% MSC definition
\newcommand{\MSC}[1]{\gdef\@MSC{#1}}
\def\@MSC{\@latex@error{No \noexpand\MSC given}\@ehc}


% Abstract environment redefined
\renewenvironment{abstract}{
      \vskip 1em\hrule\vskip 1em
      \@beginparpenalty\@lowpenalty
\noindent {\bfseries Abstract:}}%
     {\vskip 1em \noindent {\bfseries Keywords:} \@keywords \par
      \vskip 1em \noindent {\bfseries MSC:} \@MSC \vskip 1em \hrule\par\vskip 1em\thispagestyle{titlepage}}
%     {\vskip 1em \noindent {\bfseries MSC codes:} \@MSC \par\vskip 1em \hrule\par\vskip 1em\thispagestyle{titlepage}}
% Banner layout
\newcommand{\sjs@bannerjournalname}%
          {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{sc}{\sjs@journalname}}

\newcommand{\sjs@bannertexta}{\sjs@bannerjournalname}

% Comment out for papers with publication data
\newcommand{\sjs@bannerpubdata}
           {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{n}\selectfont
            {Vol. \textbf{\sjs@volume}\, No. \sjs@issue\, \sjs@year, Pages
              \sjs@declaredfirstpage--\sjs@declaredlastpage\\
              doi:\sjs@doi}
              }

% Comment out for papers submitted for review
%\renewcommand{\sjs@bannerpubdata}%
%             {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{n}\selectfont%
%             {(Submitted for review)}}%


% \newcommand{\sjs@bannerpubdata}{Article submitted for review}

\newcommand\sjs@bannertextb%
           {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{it}
            \selectfont{\sjs@bannerpubdata}}

\newcommand\sjs@bannertextc%
           {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{rm}
            \selectfont{doi:\sjs@doi}}

\newlength{\sjs@bannerwidth}
\setlength{\sjs@bannerwidth}{\textwidth}
\newcommand{\sjs@banner}{%
  \begin{minipage}{\sjs@bannerwidth}%
    \vspace*{-1cm}
    \sjs@bannertexta\\ \sjs@bannertextb \hfill \\
  \end{minipage}}

% Define the date box. If \sjs@received is
% undefined, this will simply print
% the current date, as does the article class.
\newcommand\sjs@reviseddatelayout{\ifex\sjs@revised\@empty{}\else{Revised: \sjs@revised. Accepted: \sjs@accepted}\fi}
\newcommand\sjs@datelayout%
{\fontsize{8}{10}\usefont{OT1}{ptm}{m}{sl}\selectfont%
  \ifex{\sjs@received}{\@empty}{\@date}%
  \else%
  {{Received: \sjs@received. %
	Returned: \sjs@returned. %
   \sjs@reviseddatelayout.}}%
  \fi}

\def\@maketitle{%
  \newpage
  \begin{center}%
    \sjs@banner%
  \end{center}%
  \null
  \sjs@articletype
  \vskip 1em%
  \begin{center}%
    \let \footnote \thanks
    {\huge \@title \par}%
    \vskip 1.5em%
    \bgroup
        \def\arraystretch{0.1}
    {\large
      \lineskip .1em%

      \begin{tabular}[t]{c}%
       \@author %\\ \@affiliation
      \end{tabular}\par
    }%
    \egroup
    \vskip 0.5em%
    {\sjs@datelayout}%
  \end{center}%
  \par}




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Header and footer initialization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% This defines the footer running citation. We must produce two versions of it, the one without links is used
%% to determines spacing; the other is actually used for layout.
\newcommand\sjs@runningcitation%
{\textsc{\sjs@journalname}}

\newcommand\sjs@runningcitation@nolink%
{\textsc{\sjs@journalname}}

% Header layout wrapper.
\newcommand\sjs@headerlayout[1]
   {\fontsize{8}{10}\usefont{OT1}{ptm}{m}{sc}\selectfont{#1}}
\newcommand\sjs@footerlayout[1]
   {\fontsize{8}{10}\usefont{OT1}{ptm}{m}{n}\selectfont{#1}}

% Copyright
\newcommand{\sjs@crlayout}[1]{\fontsize{6}{7}\usefont{OT1}{ptm}{m}{n}\selectfont{#1}}
\newcommand{\sjs@ccicon@text}[1]{\sjs@crlayout{$\bigcirc$\hspace{-6.6pt}\raisebox{.5pt}{\tiny{cc}}\hspace{1.5pt}}}
\newcommand{\sjs@cclogo@eps}[1]{\raisebox{-.5#1}{\includegraphics[height=#1]{LogoSJS.eps}}}
\newcommand{\sjs@ccicon@eps}[1]{\raisebox{-.5#1}{\includegraphics[height=#1]{IconSJS.eps}}}

% Set up title page style.
\newcommand{\ps@titlepage}{%
  \renewcommand{\@oddhead}{\hfil\begin{minipage}{40pt}\vspace*{15mm}\sjs@cclogo@eps{40pt}\end{minipage}\hspace*{2.5cm}}%
  \renewcommand{\@evenhead}{\@empty}%
  \renewcommand{\@oddfoot}{\small\copyright\ \sjs@copyrightauthor\hfil Published by the Spanish National Statistical Institute }%
  \renewcommand{\@evenfoot}{\small\copyright\ \sjs@copyrightauthor\hfil Published by the Spanish National Statistical Institute }%
}

% Set up the 2ff. page style.
\renewcommand{\ps@headings}{%
\renewcommand{\@oddhead}
             {\sjs@headerlayout{\sjs@runningtitle}\hfil\fontsize{9}{11}\usefont{OT1}{ptm}{m}{rm}\selectfont\thepage}%
\renewcommand{\@evenhead}
             {\fontsize{9}{11}\usefont{OT1}{ptm}{m}{rm}\selectfont\thepage\hfil\sjs@headerlayout{\sjs@runningauthor}}%
\renewcommand{\@oddfoot}
             {\hfil\sjs@footerlayout{SJS, \sjs@runningcitation}}%
\renewcommand{\@evenfoot}
             {\href{http://www.ine.es/ss/Satellite?c=Page&cid=1254735226759&pagename=ProductosYServicios\%2FPYSLayout\&L=0}{\sjs@ccicon@eps{30pt}\ \ \ }\hfil}%
}

%% Determine actual footer height.
\newlength\sjs@footerheight
\settoheight\sjs@footerheight{\sjs@footerlayout{\sjs@runningcitation@nolink}}

% Define the default page style to be headings.
\pagestyle{headings}
\pagenumbering{arabic}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Article types
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\newcommand{\articletype}{\textsc{Research Article}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Header and footer initialization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%\renewcommand\sjs@runningcitation%
%{\ifex\sjs@issue\@empty
%  {Article submitted for review}
% \else
%  {Number \sjs@issue\ (\sjs@year),
%    pp. \sjs@declaredfirstpage--\sjs@declaredlastpage}
% \fi
%}

\renewcommand\sjs@runningcitation%
{\ifex\sjs@issue\@empty
  	{Manuscript submitted for review}
 \else
  {\ifex\sjs@year\@empty
  	{Issue \sjs@issue\ (Article forthcoming)}
  	\else {Vol. \sjs@volume\, No. \sjs@issue\, (\sjs@year),  pp. \sjs@declaredfirstpage--\sjs@declaredlastpage} \fi }
 \fi
}

% Numbering within articles for long form articles.
%{\numberwithin{equation}{chapter}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PART: Macros for compact list environments
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ----------------------------------------------------
%% Copyright (c) 1993 Hydro-Quebec [EMAIL PROTECTED]
%% ----------------------------------------------------

%% Bring items closer together in list environments
% Prevent infinite loops
\let\orig@Itemize =\itemize
\let\orig@Enumerate =\enumerate
\let\orig@Description =\description
% Zero the vertical spacing parameters
\def\Nospacing{\itemsep=0pt\topsep=0pt\partopsep=0pt%
\parskip=0pt\parsep=0pt}

% Small text in tables
\renewenvironment{table}{\@float{table}[htb]\small}{\end@float}


\def\noitemsep{
% Redefine the environments in terms of the original values
\renewenvironment{itemize}{\orig@Itemize\Nospacing}{\endlist}
\renewenvironment{enumerate}{\orig@Enumerate\Nospacing}{\endlist}
\renewenvironment{description}{\orig@Description\Nospacing}%
{\endlist}
}

\def\doitemsep{
% Redefine the environments to the original values
\renewenvironment{itemize}{\orig@Itemize}{\endlist}
\renewenvironment{enumerate}{\orig@Enumerate}{\endlist}
\renewenvironment{description}{\orig@Description}{\endlist}
}

%%%% fin macro %%%%
\noitemsep

\usepackage{natbib}
\bibliographystyle{chicago_mod}
